//=============================================================================

/*:
 * @plugindesc ハードモード用アイテム数プラグイン
 * @author LefTonbo
 *
 * @param Hardmode Switch
 * @desc ハードモードを判定するスイッチ
 * @default 0
 * @type switch
 *
 * @help
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_HardmodeItemLimit = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_HardmodeItemLimit');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.HardmodeSwitch = Number(LeftPlugin.Parameters['Hardmode Switch']);

//=============================================================================

(function() {

//=============================================================================
// Game_Party
//=============================================================================

var _Game_Party_maxItems = Game_Party.prototype.maxItems;
Game_Party.prototype.maxItems = function(item) {
  if (LeftPlugin.Param.HardmodeSwitch > 0 && $gameSwitches.value(LeftPlugin.Param.HardmodeSwitch)) {
    if (item && item.meta.HardMaxItem) {
      return Number(item.meta.HardMaxItem);
    }
  }
  return _Game_Party_maxItems.apply(this ,arguments);
};

//=============================================================================

})();

// EOF